--[[ custom ]]
-- based on scripts by aj kelly; ad-hoc userprefs by asg

envTable = GAMESTATE:Env();
-- env
function setenv(name,value) envTable[name] = value; end;
function getenv(name) return envTable[name]; end;

-- file (assume stepmania 4 alpha 5)
function WriteFile(path,buf)
	local f = RageFileUtil.CreateRageFile()
	if f:Open(path, 2) then
		f:Write( tostring(buf) )
		f:destroy()
		return true
	else
		Trace( "[FileUtils] Error writing to ".. path ..": ".. f:GetError() );
		f:ClearError();
		f:destroy()
		return false
	end
end;

function ReadFile(path)
	local f = RageFileUtil.CreateRageFile()
	local ret = ""
	if f:Open(path, 1) then
		ret = tostring( f:Read() )
		f:destroy()
		return ret
	else
		Trace( "[FileUtils] Error reading from ".. path ..": ".. f:GetError() );
		f:ClearError();
		f:destroy()
		return nil
	end
end;

local prefBasePath = "Data/UserPrefs/CyberiaStyle7/";

-- ad-hoc userprefs implementation
function SetAdhocPref(pref,val)
	WriteFile(prefBasePath..pref,val);
	setenv(pref,val);
end;

function GetAdhocPref(pref)
	if getenv(pref) ~= nil then
		return getenv(pref);
	else
		local res = ReadFile(prefBasePath..pref);
		return res;
	end;
end;

function InitPrefs()
	local prefs = {
		Enable3DModels = true;
		ShowJackets = true;
	}
	for k,v in pairs(prefs) do
		if GetAdhocPref(k) == nil then
			SetAdhocPref(k,v);
		end;
	end;
end;

function OptionRow3DModels()
	local t = {
		Name = "Enable3DModels";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = false;
		Choices = { 'OFF','ON' };
		LoadSelections = function(self, list, pn)
			local pname = ToEnumShortString(pn);
			local curSet = GetAdhocPref("Enable3DModels");
			if curSet then
				list[2] = true;
			else
				list[1] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			local val = list[2] and true or false;
			SetAdhocPref("Enable3DModels",val);
		end;
	};
	setmetatable( t, t );
	return t;
end;

function ShowJackets()
	local t = {
		Name = "ShowJackets";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = false;
		Choices = { 'Off','On' };
		LoadSelections = function(self, list, pn)
			local pname = ToEnumShortString(pn);
			local curSet = GetAdhocPref("ShowJackets");
			if curSet then
				list[2] = true;
			else
				list[1] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			local val = list[2] and true or false;
			SetAdhocPref("ShowJackets",val);
		end;
	};
	setmetatable( t, t );
	return t;
end;

function UserPrefCustomSpeed()
	local t = {
		Name = "CustomSpeed";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = false;
		Choices = { 'CS6','Custom' };
		LoadSelections = function(self, list, pn)
			local pname = ToEnumShortString(pn);
			local curSet = GetAdhocPref("UserPrefCustomSpeed");
			if curSet == 'CS6' then
				list[1] = true
			elseif curSet == 'Custom' then
				list[2] = true
			else
				list[1] = true
			end;
		end;
		SaveSelections = function(self, list, pn)
			local tChoices = { "CS6","Custom" };
			local val;
			if list[1] then
				val = tChoices[1];
			elseif list[2] then
				val = tChoices[2];
			else
				val = tChoices[1];
			end
			SetAdhocPref("UserPrefCustomSpeed",val);
		end;
	};
	setmetatable( t, t );
	return t;
end;

function ScreenFilter()
	local t = {
		Name = "ScreenFilter",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { 'OFF','25%','50%','75%','100%' },
		LoadSelections = function(self, list, pn)
			if ReadPrefFromFile("ScreenFilter" .. ToEnumShortString(pn)) ~= nil then
				local bShow=GetUserPref("ScreenFilter" .. ToEnumShortString(pn));
				if bShow == 'OFF' then
					list[1] = true
				elseif bShow == '25%' then
					list[2] = true
				elseif bShow == '50%' then
					list[3] = true
				elseif bShow == '75%' then
					list[4] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave;
			if list[1] then
				bSave='OFF';
			elseif list[2] then
				bSave='25%';
			elseif list[3] then
				bSave='50%';
			elseif list[4] then
				bSave='75%';
			end;
			SetUserPref("ScreenFilter" .. ToEnumShortString(pn), bSave);
		end
	}
	setmetatable(t, t);
	return t;
end;


-- stats display
function OptionShowStats()
	local t = {
		Name="IngameStats",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { 'OFF','ON' },
		LoadSelections = function(self, list, pn)
			if GetUserPrefB("StatsDisplay" .. ToEnumShortString(pn)) then
				local bShow = GetUserPrefB("StatsDisplay" .. ToEnumShortString(pn))
				if bShow then
					list[2] = true
				else
					list[1] = true
				end
			else
				WritePrefToFile("StatsDisplay", false)
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave = list[2] and true or false
			SetUserPref("StatsDisplay" .. ToEnumShortString(pn), bSave)
		end
	}
	setmetatable(t, t)
	return t
end
